%define module_name HTTP-Caching
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Digest/MD5.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Method.pm) perl(HTTP/Request.pm) perl(HTTP/Response.pm) perl(HTTP/Status.pm) perl(List/MoreUtils.pm) perl(Moo.pm) perl(MooX/Types/MooseLike/Base.pm) perl(Readonly.pm) perl(Test/MockObject.pm) perl(Test/Most.pm) perl(Time/HiRes.pm) perl(URI.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.15
Release: alt1
Summary: The RFC 7234 compliant brains to do caching right
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VA/VANHOESEL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module tries to provide caching for HTTP responses based on
RFC 7234 Hypertext Transfer Protocol (HTTPE<sol>1.1): Caching.

Basicly it looks like the following steps below:

=over

=item

For a presented request, it will check with the cache if there is a suitable
response available AND if it can be served or that it needs to be revalidated
with an upstream server.

=item

If there was no response available at all, or non were suitable, the (modified)
request will simply be forwarded.

=item

Depending on the response it gets back, it will do one of the following
dependingon the response status code:

=over

=item 200 OK

it will update the cache and serve the response as is

=item 304 Not Modified

the cached version is valid, update the cache with new header info and serve the
cached response

=item 500 Server Error

in general, this is an error, and pass that onto the caller, however, in some
cases it could be fine to serve a (stale) cached response

=back

=back

The above is a over-simplified version of the RFC
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md
%perl_vendor_privlib/H*

%changelog
