# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec/Functions.pm) perl(FileHandle.pm) perl(HTTP/Date.pm) perl(HTTP/Request.pm) perl(IO/File.pm) perl(LWP/Online.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(POE.pm) perl(POE/Component/Client/HTTP.pm) perl(POE/Session.pm) perl(Params/Util.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name HTTP-Client-Parallel
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: A HTTP client that fetchs all URIs in parallel
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AD/ADAMK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Fetching a URI is a very common network-bound task in many types of
programming. Fetching more than one URI is also very common, but unless
the fetches are capable of entirely saturating a connection, typically
time is wasted because there is often no logical reason why multiple
requests cannot be made in parallel.

Executing IO-bound and network-bound tasks is extremely easy in any
event-based programming model such as the POE manpage, but these event-based
systems normally require complete control of the application and
that the program be written in a very different way.

Thus, the biggest problem preventing running HTTP requests in
parallel is not that it isn't possible, but that mixing procedural
and event programming is difficult.

The few existing mechanisms generally rely on forking or other
platform-specific methods.

HTTP::Client::Parallel is designed to bridge the gap between
typical cross-platform procedural code and typical cross-platform
event-based code.

It allows you to set up a series of HTTP tasks (fetching to memory,
fetching to disk, and mirroring to disk) and then issue a single
method call which will block and execute all of them in parallel.

Behind the scenes HTTP::Client::Parallel will temporarily hand
over control of the process to the POE manpage to execute the HTTP tasks.

Once all of the HTTP tasks are completed (using the standard
the POE::Component::HTTP::Client manpage module, the POE kernel will shut
down and hand control of the application back to the normal
procedural code, and thus back to your code.

As a result, a developer with no knowledge of the POE manpage or event-based
programming can still take advantage of the capabilities of POE and
gain major speed increases in HTTP-based programs with relatively
little work.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/H*

%changelog
