# BEGIN SourceDeps(oneline):
BuildRequires: perl(CGI.pm) perl(CPAN.pm) perl(Class/Accessor/Fast.pm) perl(Config.pm) perl(Cwd.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(Geo/Coordinates/Converter.pm) perl(Geo/Coordinates/Converter/iArea.pm) perl(HTTP/MobileAgent.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/More.pm) perl(Test/Requires.pm) perl(UNIVERSAL/can.pm) perl(UNIVERSAL/require.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.04
%define module_name HTTP-MobileAgent-Plugin-Locator
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Handling mobile location information plugin for HTTP::MobileAgent
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/K/KU/KURIHARA/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
use CGI;
    use HTTP::MobileAgent;
    use HTTP::MobileAgent::Plugin::Locator;

    $q = CGI->new;
    $agent = HTTP::MobileAgent->new;

    # get location is Geo::Coordinates::Converter::Point instance formatted wgs84
    # ./t/* has many examples.
    $location = $agent->get_location( $q );
    # or
    $location = $agent->get_location( { lat => '35.21.03.342',
                                        lon => '138.34.45.725',
                                        geo => 'wgs84' } );
    # or
    $location = $agent->get_location( $q, { locator => $LOCATOR_GPS } );

    # get latitude and longitude
    print "lat is " . $location->lat;
    print "lng is " . $location->lng;


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/H*

%changelog
