%set_perl_req_method relaxed
Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CGI.pm) perl(Pod/Usage.pm) perl(Test/Pod.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-HTTP-OAI
Version:        4.13
Release:        alt1_4
Summary:        API for OAI-PMH
License:        BSD-3-Clause
URL:            https://metacpan.org/release/HTTP-OAI
Source0:        https://cpan.metacpan.org/authors/id/H/HO/HOCHSTEN/HTTP-OAI-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(Module/Build/Tiny.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time:
BuildRequires:  perl(base.pm)
BuildRequires:  perl(bytes.pm)
BuildRequires:  perl(Carp.pm)
# CGI not used, bin/oai_static_gateway.pl is never executed
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(Encode.pm)
BuildRequires:  perl(Exporter.pm)
# Getopt::Long not used at tests
BuildRequires:  perl(HTTP/Headers.pm)
BuildRequires:  perl(HTTP/Request.pm)
BuildRequires:  perl(HTTP/Response.pm)
BuildRequires:  perl(LWP/MemberMixin.pm)
BuildRequires:  perl(LWP/UserAgent.pm)
BuildRequires:  perl(overload.pm)
# Pod::Usage not uset at tests
BuildRequires:  perl(POSIX.pm)
# Term::ReadKey not used at tests
# Term::ReadLine not used at tests
BuildRequires:  perl(URI.pm)
BuildRequires:  perl(utf8.pm)
BuildRequires:  perl(vars.pm)
BuildRequires:  perl(XML/LibXML.pm)
BuildRequires:  perl(XML/LibXML/SAX.pm)
BuildRequires:  perl(XML/LibXML/SAX/Builder.pm)
BuildRequires:  perl(XML/LibXML/SAX/Parser.pm)
BuildRequires:  perl(XML/LibXML/XPathContext.pm)
BuildRequires:  perl(XML/NamespaceSupport.pm)
BuildRequires:  perl(XML/SAX.pm)
BuildRequires:  perl(XML/SAX/Base.pm)
BuildRequires:  perl(XML/SAX/ParserFactory.pm)
BuildRequires:  perl(XML/SAX/Writer.pm)
# Tests:
BuildRequires:  perl(IO/File.pm)
BuildRequires:  perl(Test.pm)
BuildRequires:  perl(Test/More.pm)
Requires:       perl(Encode.pm) >= 2.120
Requires:       perl(Term/ReadLine.pm)
Requires:       perl(Term/ReadKey.pm)
Requires:       perl(XML/LibXML.pm) >= 1.600
Requires:       perl(XML/SAX/Base.pm) >= 1.040

# Remove under-specified dependencies

# Hide prive modules

Source44: import.info
%filter_from_requires /^perl(\(Encode\|Test.More\|XML.LibXML\|XML.SAX.Base\).pm)/d
%filter_from_provides /^perl(XML.SAX.Debug.pm)/d

%description
These are Perl modules and tools implementing Open Archives Initiative
Protocol for Metadata Harvesting (OAI-PMH).

%package tests
Group: Development/Perl
Summary:        Tests for %{name}
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}
Requires:       perl(Test/More.pm) >= 0.990
Requires:       perl(XML/LibXML.pm) >= 1.600
Requires:       perl(XML/SAX.pm)
Requires:       perl(XML/SAX/Base.pm) >= 1.040
Requires:       perl(XML/SAX/ParserFactory.pm)
Requires:       perl(XML/SAX/Writer.pm)

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n HTTP-OAI-%{version}

# Remove always skipped author tests
rm t/author-pod-syntax.t
perl -i -ne 'print $_ unless m{^t/author-pod-syntax.t}' MANIFEST
# Help generators to recognize Perl scripts
for F in t/*.t; do
    perl -i -MConfig -ple 'print $Config{startperl} if $. == 1 && !s{\A#!\s*perl}{$Config{startperl}}' "$F"
    chmod +x "$F"
done

%build
perl Build.PL --installdirs=vendor
./Build

%install
./Build install --destdir=%{buildroot} --create_packlist=0
# %{_fixperms} %{buildroot}/*
# Install tests
mkdir -p %{buildroot}%{_libexecdir}/%{name}
cp -a examples t %{buildroot}%{_libexecdir}/%{name}
cat > %{buildroot}%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/sh
cd %{_libexecdir}/%{name} && exec prove -I . -j "$(getconf _NPROCESSORS_ONLN)"
EOF
chmod +x %{buildroot}%{_libexecdir}/%{name}/test

%check
unset HTTP_OAI_AGENT HTTP_OAI_NETTESTS HTTP_OAI_SAX_TRACE HTTP_OAI_TRACE
export HARNESS_OPTIONS=j$(perl -e 'if ($ARGV[0] =~ /.*-j([0-9][0-9]*).*/) {print $1} else {print 1}' -- '%{?_smp_mflags}')
./Build test

%files
%doc --no-dereference LICENSE
%doc bin/oai_static_gateway.pl Changes README
%{_bindir}/oai_browser.pl
%{_bindir}/oai_pmh.pl
%dir %{perl_vendor_privlib}/HTTP
%{perl_vendor_privlib}/HTTP/OAI
%{perl_vendor_privlib}/HTTP/OAI.pm
%{_mandir}/man1/oai_browser.pl.*
%{_mandir}/man1/oai_pmh.pl.*

%files tests
%{_libexecdir}/%{name}

%changelog
