%define module_name HTTP-OAIPMH-Validator
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CGI.pm) perl(Class/Accessor/Fast.pm) perl(Crypt/SSLeay.pm) perl(Data/UUID.pm) perl(Date/Manip.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Headers.pm) perl(HTTP/Request.pm) perl(HTTP/Request/Common.pm) perl(HTTP/Status.pm) perl(JSON.pm) perl(LWP/Protocol/https.pm) perl(LWP/UserAgent.pm) perl(Test/Exception.pm) perl(Test/Pod.pm) perl(Try/Tiny.pm) perl(URI/Escape.pm) perl(XML/DOM.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.06
Release: alt1
Summary: OAI-PMH Validator used for http://www.openarchives.org/pmh/validate
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SI/SIMEON/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Validation suite for OAI-PMH data providers that checks for responses
in accord with OAI-PMH v2 
http://www.openarchives.org/OAI/2.0/openarchivesprotocol.htm.

Typical use:

  use HTTP::OAIPMH::Validator;
  use Try::Tiny;
  my $val = HTTP::OAIPMH::Validator->new( base_url=>'http://example.com/oai' );
  try {
      $val->run_complete_validation;
  } catch {
      warn "oops, validation didn't run to completion: $!\n";
  };
  print "Validation status of data provider ".$val->base_url." is ".$val->status."\n";
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.cpan.md examples
%perl_vendor_privlib/H*

%changelog
