%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Storable.pm)
# END SourceDeps(oneline)
%define module_version 0.05
%define module_name HTTP-RecordedSession
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: Class to interface with serialized clicks from Apache::Recorder
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/C/CB/CBROOKS/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
HTTP::RecordedSession will correctly format the output of Apache::Recorder 
for a script that uses either HTTP::Monkeywrench or HTTP::WebTest.

The HTTP::RecordedSession::new() method accepts a hashref with three 
possible elements:

=over 4

=item * config_id: This is the id provided by recorder.pl when you first 
begin recording an HTTP session.  This element is required.

=item * path: This is intended to provide greater portability -- you do 
not have to use the (Linux-based) default path of "/usr/tmp/", 
although RecordedSession will default to this to ensure backwards 
compatibility if no path is provided.
      

=item * test_mod: This option allows you to choose between HTTP::
Monkeywrench and HTTP::WebTest to actually test your recorded 
session.  HTTP::RecordedSession will default to 'Monkeywrench' 
to ensure backwards compatibility.

=back

There are only three public methods:

=over 4

=item * new()

=item * get_clicks: this method returns the clicks formatted for either HTTP::Monkeywrench
or HTTP::WebTest.

=item * get_id: this method returns the config_id that is passed to the 
HTTP::RecordedSession constructor.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/H*

%changelog
