# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Dumper.pm) perl(Devel/StackTrace.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec/Functions.pm) perl(HTTP/Request.pm) perl(HTTP/Response.pm) perl(HTTP/Server/Simple.pm) perl(IO/File.pm) perl(MIME/Types.pm) perl(Moose.pm) perl(Moose/Util/TypeConstraints.pm) perl(Test/HTTP.pm) perl(Test/HTTP/Syntax.pm) perl(Test/More.pm) perl(URI.pm) perl(URI/Escape.pm) perl(base.pm) perl(LWP/UserAgent.pm)
# END SourceDeps(oneline)
%define module_version 0.06
%define module_name HTTP-Server-Simple-Dispatched
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Django-like regex dispatching with request and response objects - no CGI.pm cruft!
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/F/FR/FRODWITH/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Quick and dirty regex-based dispatching inspired by Django, with standard response and request objects to ease some of the pain of HTTP::Server::Simple. Lower level than CGI.pm, which allows you to lose some of the cruft of that hoary old monster.

    use HTTP::Server::Simple::Dispatched qw(static);

    my $server = HTTP::Server::Simple::Dispatched->new(
      hostname => 'myawesomeserver.org',
      port     => 8081,
      debug    => 1,
      dispatch => [
        qr{^/hello/} => sub {
          my ($response) = @_;
          $response->content_type('text/plain');
          $response->content("Hello, world!");
          return 1;
        },
        qr{^/say/(\w+)/} => sub {
          my ($response) = @_;
          $response->content_type('text/plain');
          $response->content("You asked me to say $1.");
          return 1;
        },
        qr{^/counter/} => sub {
          my ($response, $request, $context) = @_;
          my $num = ++$context->{counter};
          $response->content_type('text/plain');
          $response->content("Called $num times.");
          return 1;
        },
        qr{^/static/(.*\.(?:png|gif|jpg))} => static("t/"),
        qr{^/error/} => sub {
          die "This will cause a 500!";
        },
      ],
    );

    $server->run();


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/H*

%changelog
