%define module_name HTTP-State
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Export/These.pm) perl(ExtUtils/MakeMaker.pm) perl(List/Insertion.pm) perl(Log/OK.pm) perl(Log/ger.pm) perl(Mozilla/PublicSuffix.pm) perl(Object/Pad.pm) perl(XS/Parse/Keyword.pm) perl(XS/Parse/Sublike.pm) perl(constant/more.pm) perl(experimental.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.2
Release: alt1
Summary: Fast RFC6265bis-draft + CHIPS Cookie Jar
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DR/DRCLAW/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
Web browsers are constantly improving privacy and limiting the tracking ability
of cookies. This module implements a cookie jar providing the same up to date
thinking to Perl user-agents. 

The algorithm implemented is derived from RFC6265bis-draft-12 and Cookies
Having Independent Partitioned State (CHIPS). These are not finalised
standards, so it is to be expected this module may change behaviour to keep up
to date.

To aid adoption, this module will work as a drop in alternative for
the HTTP::CookieJar manpage.  A compatible API has been implemented to allow existing
user agents to benefit from the performance gains in particular.

However long term, user agents would need to be modified, or at least wrapped
in order to take full advantage of this module. Not only are there differences
in the general API compared to popular cookie jars, but conceptually the notion
of 'browsing context', and 'first-party/third-party' need to be implemented.

Finally, for explicit encoding and decoding of cookie strings (not via a cookie
jar), please see the companion the HTTP::State::Cookie manpage module. This is used
internally for encoding and decoding cookies.

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes README LICENSE
%perl_vendor_privlib/H*

%changelog
