%define module_name HTTP-Validate
Epoch: 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(Module/Build.pm) perl(Scalar/Util.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.982
Release: alt1
Summary: validate and clean HTTP parameter values according to a set of rules
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MM/MMCCLENN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides validation of HTTP request parameters against a set of
clearly defined rules.  It is designed to work with the Dancer manpage, the Mojolicious manpage,
the Mason manpage, and similar web application frameworks, both for interactive apps
and for data services.  It can also be used with the CGI manpage, although the use of
the CGI::Fast manpage or another similar solution is recommended to avoid paying the
penalty of loading this module and initializing all of the rulesets over again
for each request.  Both an object-oriented interface and a procedural
interface are provided.

The rule definition mechanism is very flexible.  A ruleset can be defined once
and used with multiple URL paths, and rulesets can be combined using the rule
types `require' and `allow'.  This allows a complex application that accepts
many different paths to apply common rule patterns.  If the parameters fail
the validation test, an error message is provided which tells the client how
to amend the request in order to make it valid.  A suite of built-in validator
functions is available, and you can also define your own.

This module also provides a mechanism for generating documentation about the
parameter rules.  The documentation is generated in Pod format, which can
then be converted to HTML, TeX, nroff, etc. as needed.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/H*

%changelog
