# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Hash-AutoHash
%define upstream_version 1.17

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_10

Summary:    Object-oriented access to real and tied hashes
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Hash/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(Exporter.pm)
BuildRequires: perl(List/MoreUtils.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Scalar/Util.pm)
BuildRequires: perl(Test/Deep.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/Pod.pm)
BuildRequires: perl(Test/Pod/Content.pm)
BuildRequires: perl(Tie/Hash.pm)
BuildRequires: perl(Tie/Hash/MultiValue.pm)
BuildRequires: perl(Tie/ToObject.pm)
BuildArch:  noarch
Source44: import.info

%description
This is yet another module that lets you access or change the elements of a
hash using methods with the same name as the element's key. It follows in
the footsteps of the Hash::AsObject manpage, the Hash::Inflator manpage,
the Data::OpenStruct::Deep manpage, the Object::AutoAccessor manpage, and
probably others. The main difference between this module and its forebears
is that it supports tied hashes, in addition to regular hashes. This allows
a modular division of labor: this class is generic and treats all hashes
the same; any special semantics come from the tied hash.

The class has a 'new' method but also supplies several functions for
constructing new Hash::AutoHash objects. Except in the simplest cases, we
recommend using the constructor functions rather than 'new'.

The constructor functions shown in the SYNOPSIS are all you need for
typical uses. autohash_hash creates a new 'real' (ie, not tied)
Hash::AutoHash object; autohash_tie creates a new tied Hash::AutoHash
object. Once the objects are constructed, the class treats them the same
way.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes META.json META.yml  README
%{perl_vendor_privlib}/*


%changelog
