# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/Exception.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Hash-Digger
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0.5
Release: alt1
Summary: Access nested hash structures without vivification
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JU/JULIODCS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Allows accessing hash structures without triggering autovivification.

    my %%hash;

    $hash{'foo'}{'bar'} = 'baz';

    diggable \%%hash, 'foo', 'bar';
    # Truthy

    diggable \%%hash, 'xxx', 'yyy';
    # Falsey

    dig \%%hash, 'foo', 'bar';
    # 'baz'

    dig \%%hash, 'foo', 'bar', 'xxx';
    # undef

    exhume 'some default', \%%hash, 'foo', 'bar';
    # 'baz'

    exhume 'some default', \%%hash, 'foo', 'xxx';
    # 'some default'

    # Hash structure has not changed:
    use Data::Dumper;
    Dumper \%%hash;
    # $VAR1 = {
    #           'foo' => {
    #                      'bar' => 'baz'
    #                    }
    #         };

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README README.md Changes
%perl_vendor_privlib/H*

%changelog
