# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Module/Build.pm) perl(Scalar/Util.pm) perl(Sub/Exporter.pm) perl(Test/Deep.pm) perl(Test/More.pm) perl(Tie/Hash.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.023
%define module_name Hash-Dirty
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.023
Release: alt1
Summary: Keep track of whether a hash is dirty or not
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/R/RK/RKRIMEN/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Hash::Dirty will keep track of the dirty keys in a hash, letting you which values changed.

Currently, Hash::Dirty will only inspect a hash shallowly, that is, it does not deeply compare
the contents of supplied values (say a HASH reference, ARRAY reference, or some other opaque object).

This module was inspired by DBIx::Class::Row

Currently, setting, deleting keys or clearing the hash means that the object will lose history, so it will know
that something has changed, but not if it is reset back at some later date:

    my ($object, $hash) = Hash::Dirty->new({ a => 1 });
    $object->is_dirty; # Nope

    $hash->{a} = 2;
    $object->is_dirty; # Yup
    
    $hash->{a} = 1;
    $object->is_dirty; # Yup, still dirty, even though the original value was 1


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/H*

%changelog
