Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		perl-Hash-StoredIterator
Version:	0.008
Release:	alt7_26
Summary:	Functions for accessing a hash's internal iterator
License:	GPL-1.0-or-later OR Artistic-1.0-Perl
URL:		https://metacpan.org/release/Hash-StoredIterator
Source0:	https://cpan.metacpan.org/modules/by-module/Hash/Hash-StoredIterator-%{version}.tar.gz
# Module Build
BuildRequires:	coreutils
BuildRequires:	findutils
BuildRequires:	perl-devel
BuildRequires:	rpm-build-perl
BuildRequires:	perl-devel >= 5.10.0
BuildRequires:	perl(ExtUtils/CBuilder.pm)
BuildRequires:	perl(ExtUtils/ParseXS.pm)
BuildRequires:	perl(Module/Build.pm)
# Module Runtime
BuildRequires:	perl(B.pm)
BuildRequires:	perl(base.pm)
BuildRequires:	perl(Carp.pm)
BuildRequires:	perl(Exporter.pm)
BuildRequires:	perl(strict.pm)
BuildRequires:	perl(warnings.pm)
BuildRequires:	perl(XSLoader.pm)
# Test Suite
BuildRequires:	perl(Test2/Bundle/Extended.pm)
BuildRequires:	perl(Test2/Tools/Spec.pm)
# Dependencies
# (none)

# Avoid provides for private shared objects

Source44: import.info

%description
In perl all hashes have an internal iterator. This iterator is used by the
each() function, as well as by keys() and values(). Because these all share use
of the same iterator, they tend to interact badly with each other when nested.

Hash::StoredIterator gives you access to get, set, and init the iterator inside
a hash. This allows you to store the current iterator, use each / keys / values
etc., and then restore the iterator, which helps you to ensure you do not
interact badly with other users of the iterator.

Along with low-level get / set / init functions, there are also 2 variations of
each() that let you act upon each key/value pair in a safer way than vanilla
each().

This module can also export new implementations of keys() and values() that
stash and restore the iterator so that they are safe to use within each().

%prep
%setup -q -n Hash-StoredIterator-%{version}

%build
perl Build.PL --installdirs=vendor --optimize="%{optflags}"
./Build

%install
./Build install --destdir=%{buildroot} --create_packlist=0
find %{buildroot} -type f -name '*.bs' -empty -delete
# %{_fixperms} -c %{buildroot}

%check
./Build test

%files
%doc --no-dereference LICENSE
%doc Changes README
%{perl_vendor_archlib}/auto/Hash/
%{perl_vendor_archlib}/Hash/

%changelog
