%define module_name Hash-Typed
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(Tie/Hash.pm) perl(Type/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Ordered typed tied hashes.
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LN/LNATION/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Hash::Types;

_use Types::Standard qw/Int Str ArrayRef/;

_my $test = Hash::Typed->new(
__[
___strict => 1,
___required => 1, # all keys are required on instantiation
___keys => [
____one => Int,
____two => Str,
____three => ArrayRef,
____four => sub { return 1 },
____five => sub { 
_____Hash::Typed->new(
______[ strict => 1, required => [qw/one/], keys => [ one => Int ] ],
______%%{$_[0]}
_____);
____}
___]
__],
__(
___three => [qw/a b c/],
___two => 'def',
___one => 211,
___four => undef,
___five => { one => 633 }
__)
_);

_$test->{one} = "not okay";  # errors as does not pass Int type constraint.

_...

_tie my %%test, 'Hash::Typed',
__[
___strict => 1,
___required => [qw/one two three four/],
___keys => [
____one => Int,
____two => Str,
____three => ArrayRef,
____four => sub { return 1 },
____five => sub { Hash::Typed->new(@{$_[0]}); }
___]
__],
__(
___three => [qw/a b c/],
___two => 'def',
___one => 211,
___four => undef,
___five => [ [keys => [ one => Int ]], one => 633 ]
__);

...

_{
__one => 211, 
__two => 'def', 
__three => [qw/a b c/], 
__four => 1, 
__five => { 
___one => 633 
__}
_}

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes ignore.txt README
%perl_vendor_privlib/H*

%changelog
