%define module_name HashData
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Role/Tiny.pm) perl(Role/Tiny/With.pm) perl(Role/TinyCommons/Collection/GetItemByKey.pm) perl(Role/TinyCommons/Iterator/Resettable.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.2
Release: alt1
Summary: Specification for HashData::*, modules that contains hash data
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/HashData

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
NOTE: EARLY SPECIFICATION; THINGS WILL STILL CHANGE A LOT.

`HashData::*' modules are modules that contain hash data. The hash can be
stored in an actual Perl hash in the source code, or as lines in the DATA
section of the source code, or in other places. The hash data can be accessed
via a standard interface (see the HashDataRole::Spec::Basic manpage). Some examples of
hash data are:

=over

=item * A mapping between PAUSE IDs and CPAN author names (the HashData::CPAN::AuthorName::ByPAUSEID manpage)

=item * A mapping of ISO 2-letter country codes with their English names (the HashData::Country::EN::EnglishName::ByISO2 manpage)

=item * A mapping of answer word and their clues from New York Times 2000 cross-word puzzles, handy for generating cross-word puzzle games (the HashData::Word::EN::NYT::2000::Clue::ByWord manpage)

=item * FOLDOC dictionary, entries with their definition (the HashData::Dict::EN::FOLDOC manpage)

Also eligible for cross-word or word-guessing games.

=item * Another dictionary (the HashData::Dict::ID::KBBI manpage)

Also eligible for cross-word or word-guessing games.

=back

Why put data in a Perl module, as a Perl distribution? To leverage the Perl/CPAN
toolchain and infrastructure: 1) ease of installation, update, and
uninstallation; 2) allowing dependency expression and version comparison; 3)
ease of packaging further as OS packages, e.g. Debian packages (converted from
Perl distribution); 4) testing by CPAN Testers.

To get started, see the HashDataRole::Spec::Basic manpage and one of existing
`HashData::*' modules.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/H*

%changelog
