# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CGI.pm) perl(CGI/Carp.pm) perl(Exporter.pm) perl(Fcntl.pm) perl(FindBin.pm) perl(List/Util.pm) perl(MP3/Info.pm) perl(Sys/Hostname.pm) perl(base.pm) perl(fields.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Helios
%define upstream_version 2.83

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_6

Summary:    Helios service to index MP3s to a database table
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module//%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Config/IniFiles.pm)
BuildRequires: perl(DBI.pm)
BuildRequires: perl(Data/ObjectDriver.pm)
BuildRequires: perl(Error.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Pod/Usage.pm)
BuildRequires: perl(Test/Simple.pm)
BuildRequires: perl(TheSchwartz.pm)
BuildRequires: perl(XML/Simple.pm)
BuildArch:  noarch
Source44: import.info

%description
Helios is a system for building asynchronous distributed job processing
applications. Applications that need to process millions of small units of
work in parallel can use the Helios system to scale this work across the
multiple processes and servers that form a Helios collective. Helios may
also be used to improve the user experience on websites. By utilizing the
framework's APIs, potential timeout issues can be eliminated and response
times decreased for larger tasks invoked in response to user input. The web
server application can "fire and forget" in the background, immediately
returning control to the user. Using Helios, simple Perl applications can
be written to distribute massive workloads throughout the Helios collective
while still retaining centralized management.

The Helios module itself is merely a placeholder for versioning and
documentation purposes. If you want to require Helios (or a certain version
of it) in your package, adding

 Helios => 2.00

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std
rm -f %{buildroot}/%{perl_vendor_privlib}/README.pod

%files
%doc Changes INSTALL LICENSE META.json META.yml  README eg
%{_bindir}/*
%{_mandir}/man?/*
%{perl_vendor_privlib}/*

%changelog
