# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(List/Util.pm) perl(Moose.pm) perl(Test/More.pm) perl(common/sense.pm) perl(feature.pm)
# END SourceDeps(oneline)
%define module_version 1.05
%define module_name Helper-Deck
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.05
Release: alt1
Summary: Work with a deck of playing cards in the fashion engineered by Duane O'Brien of I.B.M. developerWor...
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/Z/ZE/ZENBAE/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
use common::sense;
    use Helper::Deck;
    
    my $d1 = Helper::Deck->new;
    my $roll1 = $d1->roll(6);
    
    my $nick1 = $d1->random_nick(('nd', 'jp', 'smoke', 'gehenna'));
    my $name1 = $d1->random_name(('james doe', 'john doe', 'jason doe', 'justin doe'));
    
    my %%scene1 = $d1->random_scenario(
        settings => [ 'the beach', 'the Yaht' ],
        objectives => [ 'get suntan', 'go swimming' ],
        antagonists => [ 'gull', 'kid' ],
        complications => [ 'very thirsty', 'very drunk' ],
    );
    
    print "I'm ", $scene1{'complication'}, " so I will ", $scene1{'objective'}, ".", "\n";
    
    my $deck1 = $d1->build_deck;
    my $deck1 = $d1->shuffle_deck($deck1);
    
    my $tc = $d1->top_card($deck1);
    
    print $d1->card_to_string($tc), " was drawn.", "\n";
    
    my $deal1 = $d1->draw($deck1, 5);
    
    print "Player 1 has been given ", $d1->card_to_string($deal1->[0]), "\n";
    print "Player 2 has been given ", $d1->card_to_string($deal1->[1]), "\n";
    print "Player 3 has been given ", $d1->card_to_string($deal1->[2]), "\n";
    print "Player 4 has been given ", $d1->card_to_string($deal1->[3]), "\n";
    print "The dealer gave himself ", $d1->card_to_string($deal1->[4]), "\n";
    
    my $odds = $d1->calculate_odds($deck1, $tc);
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README
%perl_vendor_privlib/H*

%changelog
