%define module_name Hessian-Translator
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Class/Std.pm) perl(Config.pm) perl(Contextual/Return.pm) perl(Cwd.pm) perl(DateTime.pm) perl(DateTime/Format/Epoch.pm) perl(DateTime/Format/Epoch/Unix.pm) perl(DateTime/Format/Strptime.pm) perl(Exception/Class.pm) perl(File/Spec.pm) perl(HTTP/Request.pm) perl(LWP/UserAgent.pm) perl(List/MoreUtils.pm) perl(Math/BigInt.pm) perl(Math/Int64.pm) perl(Module/Build.pm) perl(Module/Load.pm) perl(Moose.pm) perl(Perl/Critic.pm) perl(Smart/Comments.pm) perl(Test/Class.pm) perl(Test/Deep.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Time/TAI64.pm) perl(URI.pm) perl(YAML.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.06
Release: alt1
Summary: Base class for Hessian serialization/deserialization.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HE/HEYTRAV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

# TODO: package Hessian::Translator 1.03;
Provides: perl(Hessian/Translator.pm) = %version

%description
Hessian::Translator and associated subclasses and roles provides.serialization/deserialization of data and Perl datastructures into Hessian
protocol.  

On its own, this class really only provides some of the more basic functions
required for Hessian processing such as the *type list* for datatypes, the
*reference list* for maps, objects and arrays; and the *object class
definition list*.  Integration of the respective serialization and
deserialization behaviours only takes place when needed. Depending on how
the translator is initialized and which methods are called on the object, it
is possibly to specialize the object for either Hessian 1.0 or Hessian 2.0
processing and to selectively include methods for serialization and or
deserialization.  

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build --install_path bindoc=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/H*

%changelog
