%def_without test
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Cache/FileCache.pm) perl(Class/Accessor/Fast.pm) perl(Class/MOP.pm) perl(Config.pm) perl(Cwd.pm) perl(DBD/SQLite.pm) perl(DBD/mysql.pm) perl(DBIx/Class.pm) perl(DBIx/Class/ResultSet.pm) perl(DBIx/Class/Schema.pm) perl(Data/UUID.pm) perl(DateTime.pm) perl(DateTime/Event/MultiCron.pm) perl(DateTime/Format/ISO8601.pm) perl(DateTime/Set.pm) perl(Directory/Scratch.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Monitor.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(Getopt/Compact.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(LWP/UserAgent.pm) perl(List/Object.pm) perl(Log/Log4perl.pm) perl(Log/Log4perl/Level.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(POE.pm) perl(POE/API/Peek.pm) perl(POE/Component/JobQueue.pm) perl(POE/Filter/Reference.pm) perl(POE/Wheel/Run.pm) perl(Parse/CPAN/Meta.pm) perl(Path/Class/Dir.pm) perl(Socket.pm) perl(Template.pm) perl(Test/MockObject.pm) perl(Test/MockObject/Extends.pm) perl(Test/More.pm) perl(Tie/IxHash.pm) perl(UNIVERSAL/can.pm) perl(XML/LibXML.pm) perl(XML/Simple.pm) perl(YAML.pm) perl(YAML/Tiny.pm) perl(YAML/XS.pm) perl(base.pm) perl(inc/Module/Install.pm) perl(overload.pm) perl(version.pm)
# END SourceDeps(oneline)
%define module_version 0.9.2
%define module_name Hopkins
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.9.2
Release: alt1
Summary: complete multiqueue job scheduling and execution system
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DI/DIZ/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Hopkins is, in simplest terms, a better cron.  In depth,
though, Hopkins is an extensible application geared toward
the management, scheduling, and execution of both inline
perl as well as external binaries.

Hopkins's advantages include:

=over 4

=item * simple

There are many job management systems out there, varying in
complexity.  Hopkins was designed to be simple to understand
and simple to configure.

=item * agnostic implementation

While Hopkins is written in perl and will dynamically load,
instantiate, and execute any object that provides a "run"
method, it does not require your class to be aware of its
environment.  In fact, Hopkins does not require your task
to be written in perl at all.

=item * live, extensible configuration

Hopkins ships with Hopkins::Config::XML, which allows your
queues and tasks to be defined entirely in XML, validated
before load via XML Schema.  However, Hopkins::Config may
be subclassed to provide configuration any way you like.

Hopkins also provides a mechanism by which your config may
be scanned for changes.  For example, Hopkins::Config::XML
periodically checks the configuration file for changes and
validates the XML before replacing the existing config.

=item * multiple queues

Hopkins supports an infinite number of queues that each
have their own concurrency limits and behaviors upon task
failure.  Per-queue concurrencies allow you to define serial
queues (concurrency=1) or worker queues (concurrency > 1).

Each queue's behavior on task failure is configurable.  For
example, queues may be configured to halt upon task failure,
stopping the execution of queued tasks until a human has a
chance to examine the failure.

=item * multiple schedules per task

Each configured task may have a number of schedules defined,
including none.

=item * output/execution logging via DBI

Each queued task records state information to a configurable
database backend.  Information stored includes enqueue time,
time to execute, execution time, completion time, status
flags, as well as all output generated on stdout and stderr.

=item * disconnected operation

If the database backend ever becomes unavailable, Hopkins
will continue to run, queueing up database requests.

=item * extensible

Hopkins supports loadable plugins which may hook into the
running system by making use of POE.  Two plugins include
a web-based user interface (Hopkins::Plugin::HMI) as well
as a SOAP-based interface (Hopkins::Plugin::RPC).

=item * log4perl

Hopkins makes use of the excellent Log::Log4perl module for
its logging, allowing you to direct task execution errors
and other output to the appropriate parties with ease.

=item * durability

Queue (both task and database) contents are written to disk
upon entering/exiting the queue.  Thus, if the daemon were
to be restarted for any reason, it will continue processing
from where it left off.

=item * reliability

Hopkins has been used in an environment handling > 60 tasks
in four separate queues and does not eat resources.  I make
no promises as to its scalability beyond that.

=back

See the Hopkins::Manual::Configuration::XML manpage for information
on configuring Hopkins using the default XML configuration.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc license
%perl_vendor_privlib/H*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
