%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Mail/Send.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.06
%define module_name ICS-Simple
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Simple interface to CyberSource ICS2
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/W/WI/WILSOND/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Here is some basic code.  Hopefully I'll come back through soon to document it properly.

    use ICS::Simple;
    
    my $ics = ICS::Simple->new(
      ICSPath                 => '/opt/ics',
      MerchantId              => 'v0123456789', # CyberSource supplies this number to you
      Mode                    => 'test',
      Currency                => 'USD',
      Grammar                 => 'UpperCamel', # defaults to raw ICS responses, so you might want to set this
      #ErrorsTo               => 'all-errors@some.fun.place.com',
      CriticalErrorsTo        => 'only-critical-errors@some.fun.place.com',
    );
    
    my $request = {
      OrderId                 => 'order19857219',
      FirstName               => 'Fred',
      LastName                => 'Smith',
      Email                   => 'fred.smith@buyer-of-stuff.com',
      CardNumber              => '4111111111111111',
      CardCVV                 => '123',
      CardExpYear             => '2008',
      CardExpMonth            => '12',
      BillingAddress          => '123 Main St',
      BillingCity             => 'Olympia',
      BillingRegion           => 'WA',
      BillingPostalCode       => '98501',
      BillingCountryCode      => 'US',
      ShippingAddress1        => '6789 Industrial Pl',
      ShippingAddress2        => 'Floor 83, Room 11415',
      ShippingCity            => 'Olympia',
      ShippingRegion          => 'WA',
      ShippingPostalCode      => '98506',
      ShippingCountryCode     => 'US',
      ShippingFee             => '25.05',
      HandlingFee             => '5.00',
      Items                   => [
                                    { Description   => 'Mega Lizard Monster RC',
                                      Price         => '25.00',
                                      SKU           => 'prod15185' },
                                    { Description   => 'Super Racer Parts Kit',
                                      Price         => '15.30',
                                      SKU           => 'prod23523' },
                                    { Description   => 'Uber Space Jacket',
                                      Price         => '72.24',
                                      SKU           => 'prod18718' },
      ],
    };
    
    my $response = $ics->requestBill($request);
    
    if ($response->{success}) {
      print "Woo!  Success!\n";
      $response = $response->{response};
      print "Thanks for your payment of \$$response->{BillAmount}.\n";
    }
    else {
      print "Boo!  Failure!\n";
      print "Error:  $response->{error}->{description}\n";
    }


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/I*

%changelog
