# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name	 IMDB-Film
%define upstream_version 0.53

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_10

Summary:    OO Perl interface to the database of films IMDB
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/authors/id/S/ST/STEPANOV/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Cache/FileCache.pm)
BuildRequires: perl(Carp.pm)
BuildRequires: perl(Digest/SHA1.pm)
BuildRequires: perl(Error.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(HTML/Entities.pm)
BuildRequires: perl(HTML/TokeParser.pm)
BuildRequires: perl(LWP/Simple.pm)
BuildRequires: perl(Pod/Checker.pm)
BuildRequires: perl(Text/Unidecode.pm)
BuildArch:  noarch
Source44: import.info

%description
IMDB::Film is OO Perl interface to the database of films
IMDB (www.imdb.com). It allows to retrieve information
about movies by its IMDB code or title. Also, there is a 
possibility to get information about IMDB persons (actors,
actresses, directors etc) by their name of code.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor < /dev/null
%make_build

%install
%makeinstall_std

%files
%doc ChangeLog LICENSE META.json META.yml  README
%{perl_vendor_privlib}/IMDB

%changelog
