%define module_version 0.057
%define module_name IO-Die
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Errno.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Spec/Functions.pm) perl(IO/Handle.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Socket.pm) perl(Test/Deep.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/NoWarnings.pm) perl(autodie.pm) perl(base.pm) perl(Test/Class.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.057
Release: alt1
Summary: Namespaced, error-checked I/O
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/F/FE/FELIPE/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
use IO::Die;

    #Will throw on error:
    IO::Die->open( my $fh, '<', '/path/to/file' );
    IO::Die->print( $fh, 'Some output...' );
    IO::Die->close( $fh );

    #----------------------------------------------
    #...or, perhaps more usefully:

    package MyIO;

    use parent 'IO::Die';

    sub _CREATE_ERROR {
        my ( $NS, $type, %%args ) = @_;

        return MyErrorClass->new( $type, %%args );
    }

    sub _DO_WITH_ERROR {
        my ( $NS, $err ) = @_;  #$err is the result of _CREATE_ERROR() above

        return warn $err;
    }

    MyIO->open( .. );   #will warn() a MyErrorClass object on error

    #----------------------------------------------
    # You can also do:

    package MyDynamicIO;

    use parent 'IO::Die';

    sub new {
        #...something that sets an internal coderef .e'_create_err_cr.e'
    }

    sub _CREATE_ERROR {
        my ( $self, $type, %%args ) = @_;
        return $self->{'_create_err_cr'}->($type, %%args);
    }

    MyDynamicIO->sysopen( .. );     #uses .e'_create_err_cr.e' above
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/I*

%changelog
