# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Easy.pm) perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Spec.pm) perl(IO/Dir.pm) perl(Test/More.pm) perl(base.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 0.16
%define module_name IO-Easy
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.16
Release: alt1
Summary: is easy to use class for operations with filesystem objects.
Group: Development/Perl
License: perl
URL: http://perlhug.com

Source0: http://cpan.org.ua/authors/id/A/AP/APLA/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
use IO::Easy;
_
_# abstract filesystem i/o interface
_my $io = IO::Easy->new ('.');
_
_# directory interface
_my $dir = $io->as_dir;
_
_# or easy
_$dir = dir->current;
_$dir = dir->new ('.');
_
_# or even easier
_$dir = dir ('.');

_# file object "./example.txt" for unix
_my $file = $io->append ('example.txt')->as_file;
_
_# or
_$file = $io->file_io ('example.txt');

_my $content = "Some text goes here!";
_
_# Overwrite file contents with $content
_$file->store ($content); 
_
or
_
_# easier scripts: you can replace IO::Easy::Dir for dir and so on
_use IO::Easy qw(script);
_
_my $abs_path = dir->current->abs_path; # IO::Easy::Dir->current->abs_path;

_my $test_file = file->new ('test');

_$test_file->touch;

_print "ok"
__if -f $test_file and $test_file->size eq 0;
_

%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/I*

%changelog
