%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Archive/Zip.pm) perl(CPAN.pm) perl(Compress/Zlib.pm) perl(Cwd.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Spec.pm) perl(IO/File.pm) perl(IO/Zlib.pm) perl(Module/Build.pm) perl(Test/Exception.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.11
%define module_name IO-File-CompressOnClose
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: compress a file when done writing to it
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JF/JFITZ/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
To conserve disk space, it can be helpful to compress files that your
program creates as soon as possible. The IO::Zlib module is a great way to
do this, but it suffers from one (unavoidable) drawback: the files are
only accessible as compressed files.

What IO::File::CompressOnClose provides is an IO::File compatible way to
have the files created by your program written out as plain text files but
compressed when they are closed. This allows you to tail a file using a
vanilla 'tail -f' without having to worry about manually compressing the
file when direct access to it is no longer necessary.

You open a file using IO::File::CompressOnClose in much the same was as you
would open a file using IO::File (with one caveat; see below). If you
construct an object of class IO::File::CompressOnClose then the compression
scheme will be chosen based upon your platform (Zip for DOS/Windows and Gzip
for any other platform).

If you prefer to choose the specific compression scheme ahead of time you
can instantiate an object of a subclass of IO::File::CompressOnClose. The
Zip and Gzip subclasses are part of this distribution; other compression
schemes may be supported in the future.

When compression takes places, the original file is deleted; you can disable
this behaviour by setting the delete_after_compress attribute.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README ChangeLog.xml ChangeLog
%perl_vendor_privlib/I*

%changelog
