%def_without test
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(IO/File.pm) perl(IO/Select.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 1.01
%define module_name IO-File-Log
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt1
Summary: IO::File abstraction on logging files
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/L/LU/LUISMUNOZ/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Under this discussion, a log file refers to the classical notion of a
daemon's log file, that is, a file that can be appended to at any time
or that can be "rotated" (ie, the original file can be `rename()'d
and a new file with the same name created in its place).

This method provides an abstraction that allows reading operations to
occur almost transparently from those files (see CAVEATS later on for
more information). This extension deals with the possibility of the
file being rotated, appended to, etc.

Note however that the basic assumption for reading a log file, is that
it never ends. The general algorythm for this module is as follows:

=over

=item At ->new(), set the file pointer to the beginning of the file
and store the file's metadata as object state.

=item At any traditional `IO::File' operation, perform it on the
current file position and store the resulting file ponter's position.

=item At EOF, poll the system to detect a new file with the same name
given to ->new() but different metadata. When found, open this new
file and fulfill the pending operation in the new file.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README
%perl_vendor_privlib/I*

%changelog
