# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(FindBin.pm) perl(IO/Handle.pm) perl(IO/Select.pm) perl(IO/Socket.pm) perl(POSIX.pm) perl(Tie/Handle.pm) perl(base.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    IO-Socket-DNS
%define upstream_version 0.021

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_10

Summary:    IO::Socket like interface using DNS queries
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/IO/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Net/DNS.pm)
BuildArch:  noarch
Source44: import.info

%description
I originally used this module for my own purposes and never intended to
show anyone, but there have been so many requests that I've decided to
release it to the public.

Have you ever been away from your home with your computer and needed to use
the Internet, but all you can find is a crippled WiFi Access Point that
doesn't give full Internet? When you try to visit a website, it asks for an
annoying login or asks you to pay money or some other silly thing in order
to be able to use the Internet. However, usually if you actually try a dig
or nslookup, you'll notice that DNS is working perfectly fine. If so, then
this is exactly what you need!

It translates TCP connection packets into DNS queries. So now you can
finally reach that external SSH server you've been needing to reach, even
though your Internet connection is too crippled to connect to it directly.
Actually, you can connect to any TCP server, such as a Web server or an
SMTP server or a Squid proxy or even a remote SOCKS server. This client
module IO::Socket::DNS communicates with the server module
IO::Socket::DNS::Server to tunnel the connection for the client using only
DNS queries as its transport. The only thing that the Internet Service
Provider will see is a bunch of DNS queries.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes INSTALL META.yml  README
%perl_vendor_privlib/*
/usr/bin/dnsnetcat
/usr/bin/dnsssh
/usr/bin/dnstelnet
%{_mandir}/man1/dnsnetcat.1*
%{_mandir}/man1/dnsssh.1*
%{_mandir}/man1/dnstelnet.1*

/usr/bin/dnsc
/usr/bin/dnsd
%{_mandir}/man1/dnsc.1*
%{_mandir}/man1/dnsd.1*

%changelog
