# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel perl(Carp.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Temp.pm) perl(IO/Socket.pm) perl(POSIX.pm) perl(Pod/Coverage/TrustPod.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test2/Suite.pm) perl(Test2/V0.pm) perl(Time/HiRes.pm) perl(XSLoader.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name IO-SocketAlarm
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: Perform asynchronous actions when a socket changes status
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NE/NERDVANA/%{module_name}-%{version}.tar.gz

%description
Sometimes you have a blocking system call, or blocking library, and it prevents you from
checking whether the initiator of this request (like a http client) is still waiting for the
answer.  The right way to solve the problem is an event loop, where you are waiting both for
the long-tunning task and also watching for events on the client connection and your program
can respond to either of them.  Perl has several great event loops, like the Mojo::IOLoop manpage,
the AnyEvent manpage, or the IO::Async manpage with which you can build a properly engineered solution.
But... if you don't have the luxury of refactoring your whole project to be event-driven, and
you'd really just like a way to kill the current HTTP worker when the client is lost and you're
blocking in a long-running database call, this module is for you.

This module operates by creating a second C-level thread (regardless of whether your perl was
compiled with threading support) and having that thread monitor the status of your socket.

First caveat: The background thread is limited in the types of actions it can take.
For example, you definitely can't run perl code in response to the status change, but it can
send a signal to the main thread, or other process-global actions like completely exiting and
executing `mysql -e "kill $conn_id"'.

Second caveat: This module's design isn't 100%% portable beyond Linux and FreeBSD. On Windows,
MacOS, and OpenBSD there is no way (that I've found) to poll for TCP 'FIN' status.  This module
will probably still work for a HTTP worker behind a reverse proxy; see
EVENT_EOF.

Third caveat: While the module is thread-safe, per-se, it does introduce the sorts of
confusion caused by concurrency, like checking `$alarm->triggered' and having that status
change before the very next line of code in your script.

Fourth caveat: The signals you send to yourself won't take effect until control returns to
the perl interpreter.  If you are blocking in a C library or XS, it might be that the only
way to wake it up is to clo...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md LICENSE
%perl_vendor_archlib/I*
%perl_vendor_autolib/*

%changelog
