%define module_name IOas-CP932
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Copy.pm) perl(File/Path.pm) perl(FindBin.pm) perl(Jacode4e/RoundTrip.pm) perl(Socket.pm) perl(Symbol.pm) perl(Test.pm) perl(lib.pm) perl(strict.pm) perl(vars.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt1
Summary: provides CP932 I/O subroutines for UTF-8 script
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/I/IN/INA/IOas/CP932/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use IOas::CP932;

    # Octet Length as I/O Encoding
    $result = IOas::CP932::length($utf8str);
    $result = IOas::CP932::sprintf($utf8format, @utf8list);
    $result = IOas::CP932::substr($utf8expr, $offset_as_cp932x, $length_as_cp932x, $utf8replacement);

    # String Comparison as I/O Encoding
    $result = IOas::CP932::cmp($utf8str_a, $utf8str_b);
    $result = IOas::CP932::eq($utf8str_a, $utf8str_b);
    $result = IOas::CP932::ne($utf8str_a, $utf8str_b);
    $result = IOas::CP932::ge($utf8str_a, $utf8str_b);
    $result = IOas::CP932::gt($utf8str_a, $utf8str_b);
    $result = IOas::CP932::le($utf8str_a, $utf8str_b);
    $result = IOas::CP932::lt($utf8str_a, $utf8str_b);
    $result = IOas::CP932::sort(@utf8str);

    # Encoding Convert on I/O Operations
    $result = IOas::CP932::getc(FILEHANDLE);
    $result = IOas::CP932::readline(FILEHANDLE);
    $result = IOas::CP932::print(FILEHANDLE, @utf8str);
    $result = IOas::CP932::printf(FILEHANDLE, $utf8format, @utf8list);

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/I*

%changelog
