# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    IP-Info
%define upstream_version 0.18

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_3

Summary:    Interface to IP geographic and network data
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/IP/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Data/Validate/IP.pm)
BuildRequires: perl(Digest/MD5.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(HTTP/Tiny.pm)
BuildRequires: perl(JSON.pm)
BuildRequires: perl(Moo.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Throwable.pm)
BuildRequires: perl(namespace/clean.pm)
BuildArch:  noarch
Source44: import.info

%description
Quova RESTful API provides the geographic location and network data for any
Internet Protocol address in the public address space. The information
includes:

* * Postal code, city, state, region, country, and continent

* * Area code (US and Canada only) and time zone

%prep
%setup -q -n %{upstream_name}-%{upstream_version}


%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README
%{perl_vendor_privlib}/*

%changelog
