%define module_name IPC-LeaderBoard
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Spec.pm) perl(Guard.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(IPC/ScoreBoard.pm) perl(Moo.pm) perl(Path/Tiny.pm) perl(Test/CheckDeps.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(Test/Warnings.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt2
Summary: fast per-symbol online get/update information
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BI/BINARY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
LeaderBoard uses shared memory IPC to fast set/get integers on arbitrary row,
(slot) defined by it's index.

There are the following assumptions:

=over 2

=item * only one master is present

`create' method dies, if it founds that some other master ownes shared
memory (file lock is used for that).

=item * master is launched before slaves

`attach' dies, if slave finds, that master-owner isn't present, or,
if it presents, the masters provider/symbol information isn't actual.
In the last case master should be restarted first.

=item * there is no hot-deploy mechanism

Just restart master/slaves

=item * read slot before update it

The vesion/generation pattern is used do detect, whether update
has been successfull or not. Update failure means, some other
`LeaderBoard' instance updated the slot; you should re-read it
and try uptate it again (if the update will be still actual after
data refresh)

=item * no semantical difference between slave and master

Master was introduced to lock leadear board to prevent other masters
connect to it and re-initialize (corrupt) data. After attach slave validates,
that LeaderBoard is valid (i.e. number of slots, as well as the sizes
of private and shared areas match to the declared).

Hence, master can be presented only by one instance, while slaves
can be presented by multiple instances.

=item * slot data organization and consistency

A leaderboard is an array of slots of the same size:

 +------------------------------------------------------------------------+
 | slot 1                                                                 |
 +------------------------------------------------------------------------+
 | slot 2                                                                 |
 +------------------------------------------------------------------------+
 | ...                                                                    |
 +------------------------------------------------------------------------+
 | slot N                                                    ...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE README
%perl_vendor_privlib/I*

%changelog
