%define module_name IPC-Semaphore-Set
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Digest/CRC.pm) perl(ExtUtils/MakeMaker.pm) perl(IPC/Semaphore.pm) perl(IPC/SysV.pm) perl(Test/More.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.20
Release: alt1
Summary: An abstract interface to semaphore sets and their resources.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SU/SUTT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
An abstract interface to semaphore sets and their resources.

A semaphore is an abstract data type that is provided by the system
to give access control to common resources by multiple processes in
parallel programming or in a multi-user environment.

A semaphore 'set' is the set of resources the system provides by an
identification number, and the values (availability) of those resources.

Resources are the semaphores themselves in the set.

You could, for instance, use a semaphore to lock on a single file between
multiple processes by saying that the set has one resource (one file) and
that the resource has one availability (one process can use it at one time).
You could also represent a series of network printers. Perhaps you have
five printers that all have the ability to do ten jobs. You could create
the semaphore set with five resources, each resource with ten availability.

This module tries to "Do The Right Thing". It assumes a lot about what
you're looking for when you call '->new', and basically will set you up with
a semaphore set that has at least one resource with at least one availability.
If this assumption is wrong for your purposes, pay close attention to the
options for '->new'.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md README LICENSE
%perl_vendor_privlib/I*

%changelog
