# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Dumper.pm) perl(Errno.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(IO/Handle.pm) perl(POSIX.pm) perl(Test.pm) perl(Time/HiRes.pm) perl(bytes.pm) perl(lib.pm) perl(strict.pm) perl(vars.pm)
# END SourceDeps(oneline)
%define module_version 0.001002
%define module_name IPC-Semaphore-SmokeSignals
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001002
Release: alt1
Summary: A mutex and an LRU from crack pipe technology
Group: Development/Perl
License: unrestricted
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/T/TY/TYEMQ/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
A friend couldn't get APR::ThreadMutex to work so I offered to roll my own
mutual exclusion code when, *bong*, I realized this would be trivial to do
with a simple pipe.

It is easiest to use as a very simple mutex (see Synopsis above).

You can also use this as a semaphore on a relatively small number of relatively
small tokins (each tokin' must be the same number of bytes and the total
number of bytes should be less than your pipe's capacity or else you're in
for a bad trip).

It also happens to give out tokins in LRU order (least recently used).

To use it as a semaphore / LRU:

    my $bong = LightUp( 12 );
    my @pool;

    sub sharesResource
    {
        my $dragon = $bong->Puff();
        # Only 12 threads at once can run this code!

        my $puff = $dragon->Sniff();
        # $puff is '01'..'12' and is unique among the threads here now

        Do_exclusive_stuff_with( $pool[$puff-1] );
        if(  ...  ) {
            $dragon->Exhale();  # Return our tokin' prematurely
            die ExpensivePostMortem();
        }
    }

    sub stowParaphernalia
    {
        # Calling all magic dragons; waiting for them to exhale:
        $bong->Extinguish();
        ...
    }
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes
%perl_vendor_privlib/I*

%changelog
