Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-IPC-SharedCache
Version:        1.3
Release:        alt3_53
Summary:        Perl module to manage a cache in SysV IPC shared memory
License:        GPLv2+
URL:            https://metacpan.org/release/IPC-SharedCache
Source0:        https://cpan.metacpan.org/modules/by-module/IPC/IPC-SharedCache-%{version}.tar.gz
Patch0:         IPC-SharedCache-1.3-test.patch
BuildArch:      noarch
# Build
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Module
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(integer.pm)
BuildRequires:  perl(IPC/ShareLite.pm)
BuildRequires:  perl(Storable.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(vars.pm)
# Test Suite
# (no additional dependencies)
# Dependencies
Requires:       perl(IPC/ShareLite.pm) >= 0.060


Source44: import.info
%filter_from_requires /^perl(IPC.ShareLite.pm)/d

%description
This module provides a shared memory cache accessed as a tied hash.
Shared memory is an area of memory that is available to all processes.
It is accessed by choosing a key, the ipc_key argument to tie.  Every
process that accesses shared memory with the same key gets access to
the same region of memory.  In some ways it resembles a file system,
but it is not hierarchical and it is resident in memory.  This makes
it harder to use than a filesystem but much faster.  The data in
shared memory persists until the machine is rebooted or it is
explicitly deleted.


%prep
%setup -q -n IPC-SharedCache-%{version}

# Debian patch for tests, which fixes problem of HTML::Template
%patch0 -p1

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build


%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -delete
# %{_fixperms} -c %{buildroot}


%check
make test



%files
%doc --no-dereference LICENSE
%doc ANNOUNCE Changes README
%{perl_vendor_privlib}/IPC/


%changelog
