Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
BuildRequires: iptables
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-IPTables-libiptc
Version:        0.52
Release:        alt5_48
Summary:        Perl extension for iptables libiptc
# iptables/iptables.c*:             GPL-2.0-or-later
# iptables/iptables-blocking.c:     GPL-2.0-or-later
# iptables/iptables-standalone.c*   GPL-2.0-or-later
# lib/IPTables/libiptc.pm:          GPL-2.0-or-later
# ppport.h:     GPL-1.0-or-later OR Artistic-1.0-Perl
# README:       GPL-2.0-or-later
License:        GPL-2.0-or-later AND (GPL-1.0-or-later OR Artistic-1.0-Perl)
URL:            https://metacpan.org/release/IPTables-libiptc
Source0:        https://cpan.metacpan.org/authors/id/H/HA/HAWK/IPTables-libiptc-%{version}.tar.gz
# RT#70639
Patch0:         %{name}-0.51-Support-iptables-1.4.12.patch
# RT#70639
Patch1:         IPTables-libiptc-0.52-Support-for-1.4.16.2.patch
# RT#70639, bug #992659
Patch2:         IPTables-libiptc-0.52-Support-for-1.4.18.patch
# RT#70639, bug #1327038
Patch3:         IPTables-libiptc-0.52-Support-for-1.6.0.patch
# RT#70639, bug #1420338
Patch4:         IPTables-libiptc-0.52-Support-for-1.6.1.patch
# croak() expects formatting string, bug #1106081
Patch5:         IPTables-libiptc-0.52-Fix-GCC-format-security-warning.patch
# Do not link to nsl library, CPAN RT#124095
Patch6:         IPTables-libiptc-0.52-Stop-linking-against-nsl-library.patch
# Disable locking in iptables library, bug #1670047
Patch7:         IPTables-libiptc-0.52-Disable-locking.patch
# Fix make install invocation
Patch8:         IPTables-libiptc-0.52-Fix-make-install.patch
# Adapt to iptables-1.8.9, CPAN RT#70639
Patch9:         IPTables-libiptc-0.52-Adapt-to-iptables-1.8.9.patch
# Adapt to GCC 13, CPAN RT#146048
Patch10:        IPTables-libiptc-0.52-Adapt-to-GCC-13.patch
# kernel-headers >= 4.5.0-0.rc0.git6.1.fc24 and < 4.6.0-0.rc7.git3.1.fc25
# were broken, bug #1300223
BuildConflicts: kernel-headers < 4.6.0-0.rc7.git3.1.fc25
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  gcc
# Makefile.PL executes iptables program
BuildRequires:  iptables
BuildRequires:  libiptables-devel >= 1.6.0
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Config.pm)
# ExtUtils::Constant not needed
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(File/Basename.pm)
BuildRequires:  perl(File/Copy.pm)
BuildRequires:  perl(File/Spec.pm)
# Run-time:
BuildRequires:  perl(AutoLoader.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(DynaLoader.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Tests:
BuildRequires:  perl(Test/More.pm)
# Part of iptables is bundled because iptables do not provide a stable
# library API.
Provides:       bundled(iptables) = 1.6.1



# Filter bogus libiptc.so() Provides, this is intentional rpm-build feature,
# bug #1309664

Source44: import.info
%filter_from_provides /^libiptc\\.so()/d

%description
This package provides a perl interface to the netfilter/iptables C-code and
library libiptc.

%package tests
Group: Development/Perl
Summary:        Tests for %{name}
License:        GPL-2.0-or-later
BuildArch:      noarch
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n IPTables-libiptc-%{version}
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1

# Help generators to recognize Perl scripts
for F in t/*.t; do
    perl -i -MConfig -ple 'print $Config{startperl} if $. == 1 && !s{\A#!\s*perl}{$Config{startperl}}' "$F"
    chmod +x "$F"
done

%build
perl Makefile.PL PREFIX=%{_prefix} INSTALLDIRS=vendor NO_PACKLIST=1 \
    NO_PERLLOCAL=1 OPTIMIZE="$RPM_OPT_FLAGS"
%{make_build}

%install
%{makeinstall_std}
find %{buildroot} -type f -name '*.bs' -size 0 -delete
# %{_fixperms} %{buildroot}/*
# Install tests
mkdir -p %{buildroot}%{_libexecdir}/%{name}
cp -a t %{buildroot}%{_libexecdir}/%{name}
cat > %{buildroot}%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/sh
cd %{_libexecdir}/%{name} && exec prove -I . -j "$(getconf _NPROCESSORS_ONLN)"
EOF
chmod +x %{buildroot}%{_libexecdir}/%{name}/test

%check
export HARNESS_OPTIONS=j$(perl -e 'if ($ARGV[0] =~ /.*-j([0-9][0-9]*).*/) {print $1} else {print 1}' -- '%{?_smp_mflags}')
make test

%files
%doc Changes README
%dir %{perl_vendor_archlib}/auto/IPTables
%{perl_vendor_archlib}/auto/IPTables/libiptc
%dir %{perl_vendor_archlib}/IPTables
%{perl_vendor_archlib}/IPTables/libiptc.pm

%files tests
%{_libexecdir}/%{name}

%changelog
