# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Getopt/Std.pm) perl(Pod/Usage.pm) perl(Test/More.pm) perl(open.pm) perl(utf8.pm)
# END SourceDeps(oneline)
%define module_name ISO-639-3
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Language codes and names from ISO::639
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TI/TIEDEMANN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The module provides simple functions for retrieving language names and codes from the ISO-639 standards. The main purpose is to convert between different variants of codes and to get the English names of languages from codes. The module contains basic functions. There is no object-oriented interface. All functions can be exported.

    use ISO::639::3 qw/:all/;

    print convert_iso639( 'iso639-1', 'fra' );
    print convert_iso639( 'iso639-3', 'de' );
    print convert_iso639( 'name', 'fa' );

    print get_iso639_1( 'deu' );
    print get_iso639_3( 'de' );
    print get_language_name( 'de' );
    print get_language_name( 'eng' );
    print get_macro_language( 'yue' );

The module can be run as a script:

  perl ISO/639/3.pm [OPTIONS] LANGCODE*

This converts all language codes given as LANGCODE to corresponding language names. OPTIONS can be set to convert between different variants of language codes or to convert from language names to codes.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README ignore.txt LICENSE Changes
%perl_vendor_privlib/I*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
