# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Config.pm) perl(ExtUtils/MakeMaker.pm) perl(Imager.pm) perl(Imager/File/JPEG.pm) perl(MIME/Base64.pm) perl(Pod/Markdown.pm) perl(Pod/Readme.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name Image-JpegMinimal
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: create JPEG previews without headers
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/C/CO/CORION/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module implements the ideas from
https://code.facebook.com/posts/991252547593574
to create the data needed for inline previews of images that can be served
within the HTML page while keeping a low overhead of around 250 bytes per
image preview. This is achieved by splitting up the preview image into
a JPEG header which is common to all images and the JPEG image data.
With a Javascript-enabled browser, these previews will be shown until
the request for the real image has finished loading the data. This reduces
the latency and bandwidth needed until the user sees an image.

It turns the following image

=for html
  <img width="285" height="427" src="t/data/IMG_7468.JPG" />
  <img width="285" height="427" src="../../t/data/IMG_7468.JPG" />

into 250 bytes of image data representing this image:

=for html
  <img width="28" height="42" src="t/data/IMG_7468_preview.JPG" />
  <img width="28" height="42" src="../../t/data/IMG_7468_preview.JPG" />

The Javascript on the client side then scales and blurs that preview
image to create a very blurry placeholder until the real image data
arrives from the server.

=for html
  <img width="285" height="427" src="t/data/IMG_7468_blurred.JPG" />
  <img width="285" height="427" src="../../t/data/IMG_7468_blurred.JPG" />

See below for the Javascript needed to reassemble the image data
from the split header and scan data.
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.mkdn README examples
%perl_vendor_privlib/I*

%changelog
