# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Image/ExifTool.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Image-Nikon-Index
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Perl package for indexing Nikon camera image files
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SN/SNEHASIS/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Image::Nikon::Index is a simple package to restructure Nikon format
camera generated image files, which takes up a naming format easy
for indexing and archiving. The package changes default file names
into a format containing date in compact form and indexed in order
of when the photos have been taken.

For a photo taken on 2015 Jun 12 at 8:35:20, which may have been
subsequently modified at a later date or time, the name update is
as below:

  original name: DSC_2019.NEF
  date and time: 2015 Jun 12 at 8:35:20
  subtime  mexp: 30
  updated  time: 2015 Jun 12 at 18:20:10
  image newname: E612_SERIAL.NEF
  
Now, that SERIAL is generated by sorting based on date and time
for which the key is 2015061208352020150612182010, consisting of
original date, time, updated date, time. For frequent use without 
checking what is being changed and how, the following could be handy:

  use Image::Nikon::Index;
  
  chdir $ARGV[0] if defined $ARGV[0];
  my $nikon = Image::Nikon::Index->new (prefix=>'DSC', suffix=>'NEF');
  $nikon->process->transform;
  exit (0);
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/I*

%changelog
