%define module_name Image-Scale
# BEGIN SourceDeps(oneline):
BuildRequires: libgif-devel libjpeg-devel libsowing-devel perl(Audio/Scan.pm) perl(Config.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec/Functions.pm) perl(FindBin.pm) perl(GD.pm) perl(Proc/ProcessTable.pm) perl(Test/NoWarnings.pm) perl(XSLoader.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.14
Release: alt4
Summary: Fast, high-quality fixed-point image resizing
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AG/AGRUNDMA/%{module_name}-%{version}.tar.gz

%description
This module implements several resizing algorithms with a focus on low overhead,
speed and minimal features. Algorithms available are:

  GD's copyResampled (floating-point)
  GD's copyResampled fixed-point (useful on embedded devices/NAS devices)
  GraphicsMagick's assortment of resize filters (floating-point)
  GraphicsMagick's Triangle filter in fixed-point

Supported image formats include JPEG, GIF, PNG, and BMP for input, and
JPEG and PNG for output.

This module came about because we needed to improve the very slow performance of
floating-point resizing algorithms on platforms without a floating-point
unit, such as ARM devices like the SheevaPlug, and the Sparc-based ReadyNAS Duo.
Previously it would take many seconds to resize using GD on the ReadyNAS but the
conversion to fixed-point with a little assembly code brings this down to the range of
well under 1 second.

GD is also incredibly difficult to build on platforms such as Windows so we
needed a replacement.

Normal platforms will also see improvement, by removing all of the GD overhead this
version of copyResampled is around 3 times faster while also using less memory.

The fixed-point versions have an accuracy to around 4 decimal places so the quality
of floating-point vs. fixed is essentially identical.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.win32 TODO README Changes
%perl_vendor_archlib/I*
%perl_vendor_autolib/*

%changelog
