# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(GD/Image.pm) perl(Module/Build.pm) perl(Term/ExtendedColor.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.05
%define module_name Image-Term256Color
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: Display images in your 256 color terminal! (kinda)
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MO/MOSHEN/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Converts an image to 256 color terminal displayable ascii.  Mostly for fun..
    use Image::Term256Color;

    print Image::Term256Color::convert( 'myimage.jpg' ) . "\n";

Scalar context spits out a string containing term color coded text
representing the entire image.

    print Image::Term256Color::convert( 'myimage.jpg' , { scale_ratio => .5 } ) . "\n";

Scale 'myimage.jpg' by 50%% before converting.

    my @img_rows = Image::Term256Color::convert( 'myimage.jpg' );

Array context gives an array of strings.  Each string representing a row
within the image.  Unlike scalar context, there are no newlines.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build --install_path bindoc=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes README.md
%perl_vendor_privlib/I*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
