%define module_name Imager-Filter-Binarization
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(List/Util.pm) perl(Statistics/Basic.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: A collection of image binarization algorthims as image filter.
Group: Development/Perl
License: unrestricted
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GU/GUGOD/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module implements 2 different image binarization
algorithms identified by `"niblack"', and `"sauvola"'.

    $img->filter(
        type => "binarization",
        method => "niblack",
        geometry => "5x5"
    );

    $img->filter(
        type => "binarization",
        method => "sauvola",
        geometry => "5x5"
    );

The input image `$img' is assumed to be grayscale, only the first channel (red)
is used to perform binarization.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README
%perl_vendor_privlib/I*

%changelog
