%define module_name Inline-Module-LeanDist
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Copy.pm) perl(File/Find.pm) perl(File/Path.pm) perl(Inline.pm) perl(Inline/C.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.101
Release: alt2
Summary: Develop your module with Inline but distribute lean XS
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/F/FR/FRACTAL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is heavily inspired by the Inline::Module manpage. I wrote it because I wanted to be able to use the Inline manpage during development, but ship distributions that have no dependencies on it or any other module (for example the Inline::Filters manpage and its plugins). I wanted to ship distributions that were (from the user's perspective) identical to the XS dists I would have created by hand (without the Inline manpage).

Essentially, the Inline manpage compiles your code as lazily as possible which means all compilation dependencies are required at run-time. the Inline::Module manpage pushes the compilation dependencies back to build time. However, the Inline::Module::LeanDist manpage goes yet one step futher and pushes back the compilation dependencies to distribution creation time (of course the normal XS tool-chain dependency is still required).

The advantage of the the Inline::Module manpage approach over the Inline manpage is that start-up time is faster for your modules since the fairly heavy-weight the Inline manpage system isn't loaded, and a compiled version of your module is always available no matter the state of the current `.inline' directory (or which user is running the program, file-system permissions, etc).

the Inline::Module::LeanDist manpage has all of these advantages as well as some additional ones: Downloading and installing the Inline manpage is not necessary to build the distribution. This also goes for any other dependencies (such as the `ragel' binary required by the Inline::Filters::Ragel manpage).

With the Inline::Module::LeanDist manpage you don't need to worry about updates to the Inline manpage/the Inline::Module manpage/etc breaking your distribution, not that there is any more reason to expect `Inline::*' to break than say `MakeMaker' or `Test::*'. the Inline::Module manpage recommends avoiding back-compat problems by bundling hundreds of KB of the Inline manpage and its dependencies along with every distribution. I recommend against that. Fortunately there is a C`bundle => 0' option in the Inline::Module manpage to stop the bundling. Just add the required modules to your distribution's build-time pre-requisites.

Finally, with the Inline::Module::LeanDist manpage you don't need to mess around with the Inline::Module manpage's awkward "stub" packages.

On the other hand, the Inline::Module manpage will likely work for more ILSMs: this module module has only been tested with the Inline::C manpage so far. Also, although it's a bit subjective, in my opinion the Inline::Module manpage is nicer to develop with over the Inline manpage since it always puts the `.so' files into `blib/' which is more "normal" than the `.inline' directory (and of course it's nice that running `make' actually, you know, compiles your code).

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/I*

%changelog
