# BEGIN SourceDeps(oneline):
BuildRequires: perl(Compress/Zlib.pm) perl(Crypt/SSLeay.pm) perl(Data/UUID.pm) perl(Devel/Symdump.pm) perl(Digest/MD5.pm) perl(Digest/Perl/MD5.pm) perl(Exporter.pm) perl(File/stat.pm) perl(HTML/Parser.pm) perl(HTML/Tagset.pm) perl(LWP/UserAgent.pm) perl(MIME/Base64.pm) perl(Method/Alias.pm) perl(Module/Build.pm) perl(Module/Starter.pm) perl(POSIX.pm) perl(Term/ReadKey.pm) perl(Test/Builder.pm) perl(Test/Cmd.pm) perl(Test/Harness.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/TAP/Model.pm) perl(URI.pm) perl(XML/NamespaceSupport.pm) perl(XML/Parser.pm) perl(XML/SAX.pm) perl(XML/SAX/Expat.pm) perl(XML/Simple.pm) perl(YAML.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 1.057
%define module_name Integrator-Module-Build
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.057
Release: alt1
Summary: Gather and synchronize Test::More results in Cydone's Integrator
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/F/FX/FXFX/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module is used to construct perl test harnesses suitable for
use with Cydone's Integrator framework.  A test harness created with
Integrator::Module::Build can communicate test results in the style
of Test::More to Cydone Integrator and synchronise test information
(test cases, descriptions, results, log files, measurements, component
states, etc.)

Since the test harness itself is nothing less than a standard perl
module, you can use Module::Start to create a new test harness. Here
is an example on how to create a test harness called 'my-test-module'
using the module-starter script available from Module::Starter:

_module-starter _--mb _____\
___--email='my-email@cydone.com' __\
___--author='User Name'_ __\
___--module='My::Test::Module'

Then, you want to edit the Build.PL file under My-Test-Module with the
proper Integrator credentials (go to https://www.partnerscydone.com to
request your demo credentials, a specific Build.PL file will be sent
to you within a demo test harness).

Here is a typical Build.PL file used to instantiate such a perl test
harness (note the 'Integrator::Module::Build' lines):

_use strict;
_use warnings;
_use Integrator::Module::Build;

_my $builder = Integrator::Module::Build->new(
_    module_name           => 'My::Test::Module',
_    dist_author           => ' <my-email@cydone.com>',
_    
_    integrator_project_code _=> 'demo',
_    integrator_lab_code__=> 'default',
_    integrator_user_ _=> 'your username',
_    integrator_pwd__=> 'the password you received',
_    integrator_url__=> 'https://public1.partnerscydone.com',
_    integrator_http_realm_=> '',
_    integrator_http_user _=> '',
_    integrator_http_pwd  _=> '',
_);

_$builder->create_build_script();

You can now create/edit the test case files (based on Test::Simple or
Test::More style) under the ./t directory in your new test module and
synchronize the results in Integrator.

To execute the test cases and synchronize the results do:

_perl ./Build.PL
_./Build
_./Build integrator_test
_./Build integrator_sync


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/I*

%changelog
