%define module_name Interact-Later
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Cpanel/JSON/XS.pm) perl(Data/Printer.pm) perl(Data/UUID.pm) perl(File/Find/Rule.pm) perl(Module/Build/Tiny.pm) perl(Mojolicious.pm) perl(Moose.pm) perl(Path/Class.pm) perl(Storable.pm) perl(experimental.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: Delay some tasks for later by dumping their data to disk
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SM/SMONFF/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Can be used, for example, when you receive lots of `POST' requests that you
don't want to proceed right now to save database load.

This module will fastly store the data content on disk (with the Storable manpage) without
the need to use a database or a job queue. I believe as Perl is fast at writing
files to disk, we can hope good results. This is an experiment...


    use Interact::Later;

    my $delayer = Interact::Later->new(
      cache_path => 'path/to/cache',
      file_extension => '.dmp'
    );

    $delayer->write_data_to_disk($data);

    # Later...
    # Do it until there are no more files...
    $delayer->get_oldest_file_in_cache();

    # Finally
    $delayer->clean_cache;

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changes
%perl_vendor_privlib/I*

%files scripts
%_bindir/*

%changelog
