%define module_name Iterator-Merger
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(Exporter.pm) perl(ExtUtils/CBuilder.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.64
Release: alt1
Summary: an iterator to efficiently merge sorted iterators
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TD/TDRUGEON/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`Iterator::Merger' generates the fastest possible pure Perl iterator to merge sorted iterators.
Source iterators can be code references or filhandlers, and must produce a sorted output.
The generated iterator is always a code reference.

See the Implementation section for more details.

=over 4

=item imerge ITERATORS

ITERATORS is a list of either CODE or GLOB references that must generate an ascending sorted output.
This function returns a CODE reference that generate the sort-merged output of all ITERATORS.
Sorting is done using the cmp comparison operator.

CODE iterators are evaluated in scalar context until undef is returned.
GLOB iterators are evaluated in scalar context, relying on the $/ separator, until EOF.

=item imerge_num ITERATORS

Same as `imerge', but sorting is done using the <=> comparison operator.

=item imerge_raw ITERATORS

Same as `imerge', but no sorting is done, nor expected in source iterators.
Iteratos are read in order until undef is returned or EOF is reached.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changelog
%perl_vendor_privlib/I*

%changelog
