# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/SQLite.pm) perl(Iterator/Simple.pm)
# END SourceDeps(oneline)
%define module_name Iterator-Records
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: a simple iterator for arrayref record sources
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MI/MICHAEL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Iterator::Records uses the Iterator::Simple manpage to work with iterators whose values are arrayrefs of named fields. These can be called *record streams*.
A record stream can be seen as the same thing as a DBI retrieval, but without most of the machinery for DBI - and of course, a DBI query is one of the ways you
can build a record stream.

The actual API of Iterator::Records isn't as simple or elegant as the Iterator::Simple manpage, simply because there's more to keep track of. But the basic
approach is similar: an Iterator::Records object defines how to iterate something, then you use the iter() method to create an iterator from it.
The result is an Iterator::Simple iterator known to return records, i.e. arrayrefs of fields that match the field list specified.

Note that the Iterator::Records object is an iterator *factory*, and the actual iterator itself is returned by the call to iter().

  use Iterator::Records;
  
  my $spec = Iterator::Records->new (<something iterable>, ['field 1', 'field 2']);
  
  my $iterator = $spec->iter();
  while (my $row = $iterator->()) {
     my ($field1, $field2) = @$row;
  }
  
  $iterator = $spec->iter_hash();
  while (my $row = $iterator->()) {
     print $row->{field 1};
  }
  
  my ($f1, $f2);
  $iterator = $spec->iter_bind(\$f1, \$f2);
  while ($iterator->()) {
     print "$f1 - $f2\n";
  }

Note that the iterator itself is just an the Iterator::Simple manpage iterator. Now hold on, though, because here's where things get interesting.

  my $recsource = Iterator::Records->new (sub { ... }, ['field 1', 'field 2']);
  my $iterator = $recsource->select ("field 1")->iter;
  while (my $row = $iterator->()) {
     my ($field1) = @$row;
  }
  
  my @fields = $recsource->fields();
  my $fields = $recsource->fields(); # Returns an arrayref in scalar context.
  
  $rs = $recsource->where (sub { ... }, "field 1", "field 2");
  $rs = $recsource->fixup ("field 1", sub { ... } );
  $rs = $recsource->calc  ("field 3", sub { ... } );
  $rs = $rs->select ("field 2", "field 3", ...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/I*

%changelog
