%define module_name Ixchel
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config/Tiny.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Find/Rule.pm) perl(File/ShareDir.pm) perl(File/ShareDir/Install.pm) perl(File/Slurp.pm) perl(Hash/Merge.pm) perl(JSON.pm) perl(JSON/Path.pm) perl(LWP/Protocol/https.pm) perl(LWP/Simple.pm) perl(Module/List.pm) perl(Pod/Parser.pm) perl(Rex.pm) perl(String/ShellQuote.pm) perl(Template.pm) perl(Test/More.pm) perl(YAML/XS.pm) perl(YAML/yq/Helper.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.12.2
Release: alt1
Summary: Automate various sys admin stuff.
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VV/VVELOX/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Configuration and templating system meant to be used Ansible or
Rex. Config generated centeral and pushed out and templating/actions
done based on that on the remote systems for purpose of continual
integration pipe line for server configuration as well as setup.



First you will want to get a CMDB setup using like
[Shell:Var::Reader](https://github.com/VVelox/Shell-Var-Reader)
([CPAN](https://metacpan.org/dist/Shell-Var-Reader)).

This will make it easy to create easy to create the config
used by Ixchel as well as config files that can easily be shared
with other things.

Once you have everything setup and `cmdb_shell_var_reader`
working, you are ready to move on to the next step.



```
use Rex -feature => ['1.4'];
use File::Slurp;

group all => 'a.foo.bar', 'b.foo.bar;

set cmdb => {
              type           => 'TOML',
              path           => ./cmdb/,
              merge_behavior => 'LEFT_PRECEDENT',
              use_roles      => 1,
            };

desc 'Upload Server Confs';
task 'upload_server_confs',
        group => all',
        sub {
                my $remote_hostname = connection->server;

                mkdir('/usr/local/etc/ixchel');

                my @types = ( 'toml', 'yaml', 'json', 'shell' );
                foreach my $type (@types) {
                        my $type_dir = $type;
                        if ( $type eq 'shell' ) {
                                $type = 'sh';
                        }
                        my $upload_from = $type_dir . '_confs/' . $remote_hostname . '.' . $type;
                        if ( -f $upload_from ) {
                                my $content=read_file($upload_from);
                                file '/usr/local/etc/ixchel/server.' . $type, content => $content;
                        }
                } ## end foreach my $type (@types)
        };
```


```
- hosts: "{{ host }}"
  order: sorted
  gather_facts: false
  ignore_errors: true
  ignore_unreachable: true
  become: true
  become_method: sudo
  serial: 1

  tasks:
  - name: Copy System JSON Conf Into Place
    ansible.builtin.copy:
      src: ./json_confs/{{ inventory_hostname }}.json
      dest: /usr/local/etc/ixchel/server.json

  - name: Copy System Shell Conf Into Place
    ansible.builtin.copy:
      src: ./shell_confs/{{ inventory_hostname }}.conf
      dest: /usr/local/etc/ixchel/server.conf

  - name: Copy System YAML Conf Into Place
    ansible.builtin.copy:
      src: ./yaml_confs/{{ inventory_hostname }}.yaml
      dest: /usr/local/etc/ixchel/server.yaml

  - name: Copy System TOML Conf Into Place
    ansible.builtin.copy:
      src: ./toml_confs/{{ inventory_hostname }}.toml
      dest: /usr/local/etc/ixchel/server.toml
```

And if you wish to use the generated JSON config file with a system in
a Ansible task, it can be done like below.

```
- hosts: "{{ host }}"
  var_files:
    - ./json_confs/{{ inventory_hostname }}.json
```


If generating the configs via Shell::Var::Reader, the generated shell
conf file can easily be included in sh, zsh, and bash scripts like below.

```
. /usr/local/etc/ixchel/server.sh
```

That said it is worth nothing these do not include any of the default
variables for Ixchel. Only those that have been explicitely set via
the CMDB.


Perl modules needed.

- Config::Tiny
- Data::Dumper
- File::Find::Rule
- File::ShareDir
- File::Slurp
- Hash::Merge
- JSON
- JSON::Path
- LWP::Simple
- Module::List
- Rex
- String::ShellQuote
- TOML
- Template
- YAML::XS

Other Libraries.

- libyaml


1. `apt-get install libconfig-tiny-perl libfile-find-rule-perl
libfile-sharedir-perl libfile-slurp-perl libhash-merge-perl
libjson-perl libjson-path-perl libwww-perl rex
libstring-shellquote-perl libtoml-perl libtemplate-perl
libyaml-libyaml-perl cpanminus`
2. `cpanm Ixchel`


1. `pkg intall p5-Config-Tiny p5-Data-Dumper p5-File-Find-Rule
p5-File-ShareDir p5-File-Slurp p5-Hash-Merge p5-JSON p5-JSON-Path
p5-libwww p5-Module-List p5-Rex p5-String-ShellQuote p5-TOML
p5-Template-Toolkit p5-YAML-LibYAML p5-App-cpanminus`
2. `cpanm Ixchel`


- sub path selection for xeno when passing hashes
- Suricata/Sagan config comparison
- add in file_cleaner_by_du support
- Apache config management(genearlized manner)
- actions for...
  - Lilith
_- install client
_- db server setup
  - Suricata::Extract
  - CAPEv2
  - autocron template
  - extend_logsize template
  - snmp_v2 template
  - snmp setup
- better documentation for Suricata outputs
- use File::Spec->canonpath every where relevant
- lots more documentation

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md
%perl_vendor_privlib/I*
%perl_vendor_privlib/auto/*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
