%define module_name JIP-Daemon
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Capture/Tiny.pm) perl(Carp.pm) perl(English.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(JIP/ClassField.pm) perl(Mock/Quick.pm) perl(POSIX.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.041
Release: alt1
Summary: Daemonize server process.
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VL/VLADIMIRZ/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Just run:

    use JIP::Daemon;

    my $proc = JIP::Daemon->new;

    # Send program to backgroung.
    $proc = $proc->daemonize;

    # In the backgroung process:
    $proc->is_detached; # 1
    $proc->try_kill(0); # 1
    printf qq{pid(%%s), is_alive(%%d), is_detached(%%d)\n}, $proc->status;

    # If the program is already a running background job, the daemonize method shall have no effect.
    $proc = $proc->daemonize;

Dry run:

    use JIP::Daemon;

    my $proc = JIP::Daemon->new(dry_run => 1);

    $proc->daemonize;

    # In the same process
    $proc->is_detached; # 0

With logger:

    use Mojo::Log;
    use JIP::Daemon;

    my $proc = JIP::Daemon->new(logger => Mojo::Log->new);

    $proc->daemonize;

With on_fork_callback:

    use JIP::Daemon;

    my $proc = JIP::Daemon->new(
        on_fork_callback => sub {
            # After daemonizing, and before exiting,
            # run the given code in parent process
            print $proc->pid;
        },
    )->daemonize;
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/J*

%changelog
