%define module_name JIP-Object
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(English.pm) perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.031
Release: alt1
Summary: A simple object system.
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VL/VLADIMIRZ/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Test::More;
    use JIP::Object;

    my $obj = JIP::Object->new;
    ok $obj, 'got object';

    # Public access to the "foo"
    $obj->has('foo', (get => '+', set => '+'));
    is($obj->set_foo(42)->foo, 42);

    # Private access to the "bar"
    $obj->has('bar', (get => '-', set => '-'));
    is($obj->_set_bar(42)->_bar, 42);

    # Create user-defined names for getters/setters
    $obj->has('wtf' => (get => 'wtf_getter', set => 'wtf_setter'));
    is($obj->wtf_setter(42)->wtf_getter, 42);

    # Pass an optional first argument of setter to set
    # a default value, it should be a constant or callback.
    $obj->has('baz' => (get => '+', set => '+', default => 42));
    is($self->set_baz->baz, 42);

    $obj->has('qux' => (get => '+', set => '+', default => sub {
        my $self = shift;
        return $self->baz;
    }));
    is($self->set_qux->qux, 42);

    # Define a new method
    $obj->method('say_foo', sub {
        my $self = shift;
        print $self->foo, "\n";
    });

    done_testing();
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/J*

%changelog
