%define module_name JIP-Spy-Events
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(English.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0.5
Release: alt1
Summary: >new;
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VL/VLADIMIRZ/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
Testing with the Test::More manpage:

    use Test::More;

    use_ok 'JIP::Spy::Events';

    my $spy_events = JIP::Spy::Events->new;

    is_deeply $spy_events->events, [];
    is_deeply $spy_events->times,  {};

    is $spy_events->foo,     $spy_events;
    is $spy_events->foo(42), $spy_events;

    is_deeply $spy_events->events, [
        { method => 'foo', arguments => [] },
        { method => 'foo', arguments => [42] },
    ];

    is_deeply $spy_events->times, { foo => 2 };

    is $spy_events->clear, $spy_events;

    is_deeply $spy_events->events, [];
    is_deeply $spy_events->times,  {};

    done_testing;

Testing with the Test::More manpage, and want_array is turning on:

    use Test::More;

    use_ok 'JIP::Spy::Events';

    my $spy_events = JIP::Spy::Events->new(want_array => 1);

    $spy_events->foo;
    scalar $spy_events->foo;
    ( () = $spy_events->foo );

    is_deeply $spy_events->events, [
        { method => 'foo', arguments => [], want_array => undef },
        { method => 'foo', arguments => [], want_array => q{} },
        { method => 'foo', arguments => [], want_array => 1 },
    ];

    done_testing;

FizzBuzz example:

    use Test::More;

    use_ok 'JIP::Spy::Events';

    my $spy_events = JIP::Spy::Events->new;

    $spy_events->on_spy_event(
        just_do_it => sub {
            my ($spy, $event) = @_;

            my $attempt = $event->arguments->[0];

            return (
                !($attempt %% 3)  ? 'Fizz' :
                !($attempt %% 5)  ? 'Buzz' :
                $attempt
            );
        },
    );

    my @results = map { $spy_events->just_do_it($_) } 1 .. 5;

    is_deeply \@results, [
        1,
        2,
        'Fizz',
        4,
        'Buzz',
    ];

    done_testing;

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/J*

%changelog
