# BEGIN SourceDeps(oneline):
BuildRequires: perl(APR/Table.pm) perl(Apache2/Const.pm) perl(Apache2/RequestIO.pm) perl(Apache2/RequestRec.pm) perl(CGI.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Server/Simple.pm) perl(HTTP/Server/Simple/CGI.pm) perl(JSON/XS.pm) perl(LWP.pm) perl(LWP/UserAgent.pm) perl(Scalar/Util.pm) perl(StoredHash.pm) perl(Test/More.pm) perl(base.pm) perl(nginx.pm) perl(threads.pm)
# END SourceDeps(oneline)
%define module_version 0.61
%define module_name JRPC
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.61
Release: alt1
Summary: Fast and extensible JSON-RPC Service Framework (CGI/mod_perl/Nginx)
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/O/OH/OHOLLMEN/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
JRPC Module bundle consists of Server and Client pieces for creating JSON-RPC services.
For the server piece it takes a slightly different approach than many other "API Heavy" CPAN modules.
Instead of assembing your service out of API calls, JRPC forms a framework on top of your implementation and
allows you to write a (single) callback:

=over 4

=item * receiving parameters (JSON-RPC "params") of the of JSON-RPC call pre-parsed, ready-to be worked with by your app code

=item * returning the "result" data (to framework taking care of JSON-RPC)

=back

The callback should be wrapped into a class package. One package can host multiple service methods.

When any exception is thrown (by die()) during the processing by callback, the framework takes care of turning this to an appropriate JSON-RPC fault.
The framework will also take care of dealing with JSON-RPC "envelope" (term borrowed from SOAP lingo) of both request and response, "unwrapping" it
on request and wrapping the result with it on response.

   package MyEchoService;
   our $VERSION = '0.01';
   
   # Respond with whatever was sent
   sub echo {
      my ($param) = @_;
      # Pass-through - Just send the "params" as "result"
      return($param);
   }

%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README examples
%perl_vendor_privlib/J*

%changelog
